﻿using System;
using System.Collections.Generic;
using System.Linq.Expressions;
using DAL;

namespace BLL
{
    public class ManageContacts
    {
        
        public IEnumerable<Contact> GetContacts()
        {
            IEnumerable<Contact> contacts;
            using (UnitOfWork unitOfWork = new UnitOfWork())
            {
                contacts = unitOfWork.ContactRepository.GetAll();
            }
            return contacts;
        }
       
        public bool AddContact(Contact contact)
        {
            using (UnitOfWork unitOfWork = new UnitOfWork())
            {
                unitOfWork.ContactRepository.Add(contact);
                unitOfWork.Save();
            }
            return true;
        }
       
        public bool UpdateContact(Contact contact, int id)
        {
            using (UnitOfWork unitOfWork = new UnitOfWork())
            {
                var contactEntity = unitOfWork.ContactRepository.GetById(id);
                contactEntity.Title = contact.Title;
                contactEntity.FirstName = contact.FirstName;
                contactEntity.LastName = contact.LastName;
                contactEntity.ModifiedDate = DateTime.Now;
                unitOfWork.Save();
            }
            return true;
        }
        
        public bool DeleteContact(int id)
        {
            using (UnitOfWork unitOfWork = new UnitOfWork())
            {
                Contact contact = unitOfWork.ContactRepository.GetById(id);
                unitOfWork.ContactRepository.Delete(contact);
                unitOfWork.Save();
            }
            return true;
        }

        
        public List<Contact> GetContactPaged(int page, int rows, out int totalCount)
        {
            List<Contact> contacts;
            using (UnitOfWork unitOfWork = new UnitOfWork())
            {
                contacts = unitOfWork.ContactRepository.GetContactPaged(page, rows, out totalCount);
            }
            return contacts;
        }
        public Contact GetById(int id)
        {
            Contact contact;
            using (UnitOfWork unitOfWork = new UnitOfWork())
            {
                contact = unitOfWork.ContactRepository.GetById(id);
            }
            return contact;
        }

    }
}
